/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

#define		SHADOW_EPSILON 0.0005f
float4x4	g_shadowerTransform;
float		g_light_farPlane;
float		shader_misc_shadow_mapSize;
float		shader_misc_shadow_mapTexelSize;

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4  position	: POSITION;
	float4  speed		: NORMAL;
	float4  colour		: COLOR;
	float2  tex0		: TEXCOORD0;
	float2  shapeVector	: TEXCOORD1;
	float2	size		: TEXCOORD2;
};

struct VS_OUTPUT
{
	float4 position		: POSITION;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT vs_standardParticle( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;
	
	output.position = mul(input.position, shader_transform_viewProj);
	
	output.position.x = output.position.x + (input.shapeVector.x * input.size.x);
	output.position.y = output.position.y + (input.shapeVector.y * input.size.x);
	output.colour = input.colour;
	output.tex0 = input.tex0;

	return output;
}

////////////////////////////////////////////////////////////
// techniques

technique tech_standardParticle_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_standardParticle();	
	}
}
